package ThematicModelProto;

import java.util.HashSet;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Motif{
	
	private HashSet<String> features = new HashSet<String>();
	private String name; 
	
	
	
	public Motif(String name, String file){
		String fileName = file+name.toLowerCase().replace(" ", "")+".te";
		//System.out.println(fileName);
		parseDocument(fileName);
	}
	
	private void parseDocument(String file){
		Document dom = Helpers.parseXmlFile(file);
		
		//get the root element
		Element docEle = dom.getDocumentElement();
		
		name = docEle.getAttribute("name");
		
		//get a node list of  elements
		NodeList nl = docEle.getElementsByTagName("feature");
		
		if(nl == null) {return;} //Not actually sure this can ever happen and tbh im pretty sure even if it does the code will crash somewhere else
		
		for(int i = 0 ; i < nl.getLength();i++) {
			
			Node el = nl.item(i);
			//System.out.println(el.getFirstChild().getNodeValue());
			features.add(el.getFirstChild().getNodeValue()); // yes this is a bit dangerous but the dom implementation is retarded
		
		}
		
		
	}
	
	public HashSet<String> getFeatures(){
		return features;
	}
	
	public String getName(){
		return name;
	}
	
	
}